import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { InputSize } from 'shared/consts/InputSize';
import { InputPhoneNumber, InputPhoneNumberProps } from 'shared/ui/InputPhoneNumber/InputPhoneNumber';

const storybookMeta = createStorybookMeta<InputPhoneNumberProps>({
    title: 'shared/InputPhoneNumber',
    component: InputPhoneNumber,

    args: {
        storybookWidth: '320px',

        inputSize: InputSize.M,
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<InputPhoneNumberProps>(InputPhoneNumber);

export const empty = Template.bind({});

export const normal = Template.bind({});
normal.args = { value: '+375291000000' };

export const partial = Template.bind({});
partial.args = { value: '375' };

export const invalid = Template.bind({});
invalid.args = { value: 'abc' };
