import * as React from 'react';

import { Input, InputProps } from 'shared/ui/Input/Input';

export interface InputPhoneNumberProps extends InputProps {
    className?: string;
}

export const PHONE_START_SYMBOL = '+';

export const InputPhoneNumber: React.FC<InputPhoneNumberProps> = function InputPhoneNumber({
    className,
    value,
    onInputChange,
    ...otherProps
}) {
    const [phoneNumber, setPhoneNumber] = React.useState<string>(value as string);

    const setValue = React.useCallback((value: string) => {
        setPhoneNumber(value ? (value[0] === PHONE_START_SYMBOL ? value : PHONE_START_SYMBOL + value) : '');
    }, []);

    React.useEffect(() => {
        setValue(phoneNumber);

        if (onInputChange) {
            onInputChange(phoneNumber);
        }
    }, [onInputChange, phoneNumber]);

    const onChangeHandler = React.useCallback((value: string) => {
        setValue(value);
    }, []);

    return (
        <Input
            {...otherProps}
            className={className}
            inputMode="numeric"
            pattern="\+\d*"
            value={phoneNumber}
            onInputChange={onChangeHandler}
        />
    );
};
