import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { InputSize } from 'shared/consts/InputSize';
import { InputSearch, InputSearchProps } from 'shared/ui/InputSearch/InputSearch';

const storybookMeta = createStorybookMeta<InputSearchProps>({
    title: 'shared/InputSearch',
    component: InputSearch,

    args: {
        storybookWidth: '320px',

        inputSize: InputSize.M,
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<InputSearchProps>(InputSearch);

export const normal = Template.bind({});

export const full = Template.bind({});
full.args = {
    value: 'Hello world!',
};
