import * as React from 'react';
import cn from 'classnames';

import { InputSize } from 'shared/consts/InputSize';
import { Input, InputProps } from 'shared/ui/Input/Input';
import { InputIcon } from 'shared/ui/InputIcon/InputIcon';

import SearchIcon from 'shared/ui/Icons/images/search-16.inline.svg';

import styles from 'shared/ui/InputSearch/InputSearch.css';

export interface InputSearchProps extends InputProps {
    className?: string;
}

export const InputSearch: React.FC<InputSearchProps> = function InputSearch({ className, ...otherProps }) {
    return (
        <Input
            {...otherProps}
            className={cn(styles.inputSearch, className)}
            inputSize={InputSize.M}
            type="search"
            inputMode="search"
            hasClear
        >
            <InputIcon
                className={styles.iconSearch}
                icon={SearchIcon}
                visible
            />
        </Input>
    );
};
