import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { Island, IslandProps } from 'shared/ui/Island/Island';

const storybookMeta = createStorybookMeta<IslandProps>({
    title: 'shared/Island',
    component: Island,

    args: {
        title: 'Title',
        children: <div style={{ width: '320px', height: '320px' }} />,
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<IslandProps>(Island);

export const normal = Template.bind({});
