import * as React from 'react';
import cn from 'classnames';

import { IslandTheme } from 'shared/consts/IslandTheme';
import { Widget } from 'shared/ui/Widget/Widget';

import styles from 'shared/ui/Island/Island.css';

export interface IslandProps {
    className?: string;
    title?: React.ReactNode;
    theme?: IslandTheme;

    'data-id'?: string;
    onMouseEnterItem?(event: React.MouseEvent<HTMLDivElement>): void;
    onMouseLeaveItem?(): void;
    onClick?(event: React.MouseEvent<HTMLDivElement>): void;
}

export const Island: React.FC<IslandProps> = function Island({
    className,
    title,
    theme = IslandTheme.WHITE,
    children,
    onMouseEnterItem,
    onMouseLeaveItem,
    onClick,
    ...props
}) {
    return (
        <Widget
            className={cn(styles.island, [theme === IslandTheme.GRAY ? styles.gray : styles.white, className])}
            onMouseEnterItem={onMouseEnterItem}
            onMouseLeaveItem={onMouseLeaveItem}
            onClick={onClick}
            data-id={props['data-id']}
        >
            {typeof title === 'string' ? (
                <h3 className={styles.title}>{title}</h3>
            ) : (
                title && <div className={styles.title}>{title}</div>
            )}

            {children}
        </Widget>
    );
};
