import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { LayoutContainer, LayoutContainerProps } from 'shared/ui/LayoutContainer/LayoutContainer';

import styles from 'shared/ui/LayoutContainer/LayoutContainer.story.css';

const storybookMeta = createStorybookMeta<LayoutContainerProps>({
    title: 'shared/LayoutContainer',
    component: LayoutContainer,

    args: {
        storybookWidth: '968px',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<LayoutContainerProps>(LayoutContainer);

const header = <div className={styles.storyHeader} />;
const filters = <div className={styles.storyFilters} />;

export const normal = Template.bind({});

export const onlyHeader = Template.bind({});
onlyHeader.args = { header };

export const onlyFilters = Template.bind({});
onlyFilters.args = { filters };

export const full = Template.bind({});
full.args = { header, filters };
