import * as React from 'react';
import cn from 'classnames/bind';

import styles from 'shared/ui/LayoutContainer/LayoutContainer.css';

export interface LayoutContainerProps {
    header?: React.ReactNode;
    filters?: React.ReactNode;

    // @todo: temporary props
    bodyScroll?: boolean;
}

const cx = cn.bind(styles);

export const LayoutContainer: React.FC<LayoutContainerProps> = function LayoutContainer({
    header,
    filters,
    bodyScroll,
    children,
}) {
    return (
        <section
            className={cx(styles.layoutContainer, {
                widthHeader: Boolean(header),
                widthFilters: Boolean(filters),
                bodyScroll,
            })}
        >
            {header && <div className={styles.header}>{header}</div>}

            {filters && <div className={styles.filters}>{filters}</div>}

            <div className={styles.content}>{children}</div>
        </section>
    );
};
