import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { hoverState } from 'tests/storybook/helpers/hoverState';

import { LinkColor } from 'shared/consts/LinkColor';
import { Link, LinkProps } from 'shared/ui/Link/Link';

const storybookMeta = createStorybookMeta<LinkProps>({
    title: 'shared/Link',
    component: Link,

    args: {
        children: 'Link',
        href: 'https://yandex.ru',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<LinkProps>(Link);

export const blue = Template.bind({});
blue.hermioneFn = hoverState;

export const black = Template.bind({});
black.args = { color: LinkColor.BLACK };
black.hermioneFn = hoverState;

export const disabled = Template.bind({});
disabled.args = { disabled: true };
disabled.hermioneFn = hoverState;
