import * as React from 'react';
import cn from 'classnames/bind';

import { LinkColor } from 'shared/consts/LinkColor';

import styles from 'shared/ui/Link/Link.css';

export type LinkAttributes = (JSX.IntrinsicElements['a'] & JSX.IntrinsicElements['span']) & {
    'data-c'?: string;
    'data-disable-counters'?: string;
    'data-original-href'?: string;
};

export interface LinkProps extends LinkAttributes {
    className?: string;
    color?: LinkColor;
    disabled?: boolean;
}

const cx = cn.bind(styles);

export const Link: React.FC<LinkProps> = React.memo(function Link({
    className,
    color = LinkColor.BLUE,
    disabled,
    children,
    ...otherProps
}) {
    const TagName: string = otherProps.href && !disabled ? 'a' : 'span';

    let attrs: LinkAttributes = {
        ...otherProps,
        className: cx(styles.link, { disabled }, [color, className]),
    };

    if (!disabled) {
        attrs.role = 'link';
        attrs.tabIndex = 0;
    }

    return <TagName {...attrs}>{children}</TagName>;
});
