import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { MenuType } from 'shared/consts/MenuType';
import { Menu, MenuProps } from 'shared/ui/Menu/Menu';

const storybookMeta = createStorybookMeta<MenuProps>({
    title: 'shared/Menu',
    component: Menu,

    args: {
        storybookWidth: '320px',

        items: [
            {
                label: 'Driver',
                value: 'driver',
            },
            {
                label: 'Car',
                value: 'car',
            },
            {
                label: 'Licence plate number',
                value: 'licence-number',
            },
            {
                label: 'Mileage',
                value: 'mileage',
            },
        ],
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<MenuProps>(Menu);

export const normal = Template.bind({});

export const typeCheck = Template.bind({});
typeCheck.args = {
    menuType: MenuType.CHECK,
    selected: 'drive',
    checked: ['car', 'licence-number'],
};

export const typeRadio = Template.bind({});
typeRadio.args = { menuType: MenuType.RADIO, selected: 'drive', checked: 'licence-number' };

export const shadow = Template.bind({});
shadow.args = { shadow: true };
