import * as React from 'react';
import cn from 'classnames/bind';

import { MenuItem, MenuItemOptions, MenuItemProps } from 'shared/ui/MenuItem/MenuItem';

import styles from 'shared/ui/Menu/Menu.css';

export interface MenuProps<T extends string = string>
    extends Pick<MenuItemProps<T>, 'menuType' | 'visibleCheck' | 'onItemClick'> {
    className?: string;
    style?: React.CSSProperties;
    shadow?: boolean;
    items: MenuItemOptions[];
    checked?: T | T[];
    selected?: T;
}

const cx = cn.bind(styles);

export const Menu = React.forwardRef<HTMLDivElement, MenuProps>(function Menu(
    { className, style, checked, selected, shadow, items, ...otherProps },
    ref,
) {
    if (!items.length) {
        return null;
    }

    return (
        <div
            className={cx(styles.menu, { shadow }, [className])}
            style={style}
            ref={ref}
            role="menu"
        >
            <ul className={styles.list}>
                {items.map((item) => {
                    const value = item.value;
                    const isChecked = Array.isArray(checked) ? checked.includes(value) : checked === value;

                    return (
                        <MenuItem
                            {...item}
                            {...otherProps}
                            checked={isChecked}
                            selected={selected === value}
                            key={value}
                        />
                    );
                })}
            </ul>
        </div>
    );
}) as <T extends string = string>(
    props: MenuProps<T> & React.RefAttributes<HTMLDivElement>,
) => React.ReactElement<MenuProps<T> & React.RefAttributes<HTMLDivElement>> | null;
