import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { hoverState } from 'tests/storybook/helpers/hoverState';

import { MenuType } from 'shared/consts/MenuType';
import { MenuItem, MenuItemProps } from 'shared/ui/MenuItem/MenuItem';

const storybookMeta = createStorybookMeta<MenuItemProps>({
    title: 'shared/MenuItem',
    component: MenuItem,

    args: {
        storybookWidth: '320px',

        label: 'Send the car to a service',
        value: 'service',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<MenuItemProps>(MenuItem);

export const normal = Template.bind({});
normal.hermioneFn = hoverState;

export const typeCheck = Template.bind({});
typeCheck.args = { menuType: MenuType.CHECK };
typeCheck.hermioneFn = hoverState;

export const hiddenCheck = Template.bind({});
hiddenCheck.args = { menuType: MenuType.CHECK, visibleCheck: false };
hiddenCheck.hermioneFn = hoverState;

export const long = Template.bind({});
long.args = {
    label: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
    value: 'long',
};
long.hermioneFn = hoverState;

export const longCheck = Template.bind({});
longCheck.args = {
    label: 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
    value: 'long',
    menuType: MenuType.CHECK,
};
longCheck.hermioneFn = hoverState;

export const checked = Template.bind({});
checked.args = { menuType: MenuType.CHECK, checked: true };
checked.hermioneFn = hoverState;

export const checkedHidden = Template.bind({});
checkedHidden.args = { menuType: MenuType.CHECK, checked: true, visibleCheck: false };
checkedHidden.hermioneFn = hoverState;

export const selected = Template.bind({});
selected.args = { selected: true };
selected.hermioneFn = hoverState;

export const disabled = Template.bind({});
disabled.args = { disabled: true };
