import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { ModalContainer, ModalContainerProps } from 'shared/ui/ModalContainer/ModalContainer';

const storybookMeta = createStorybookMeta<ModalContainerProps>({
    title: 'shared/ModalContainer',
    component: ModalContainer,

    hermioneSelector: 'html',

    args: {
        children: <div style={{ height: '350px', backgroundColor: 'pink' }} />,
    },
});

export default storybookMeta;

const TITLE = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry';
const DESCRIPTION =
    "Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.";

const Template = createStorybookTemplate<ModalContainerProps>(ModalContainer);

export const withTitle = Template.bind({});
withTitle.args = { title: TITLE };

export const withDescription = Template.bind({});
withDescription.args = {
    title: TITLE,
    description: DESCRIPTION,
};

export const withClose = Template.bind({});
withClose.args = {
    title: TITLE,
    description: DESCRIPTION,
    hasClose: true,
};

export const onlyClose = Template.bind({});
onlyClose.args = { hasClose: true };
