import * as React from 'react';
import cn from 'classnames';

import { usePortal } from 'shared/hooks/usePortal/usePortal';
import { usePreventScroll } from 'shared/hooks/usePreventScroll/usePreventScroll';
import { BaseDialog, BaseDialogProps } from 'shared/ui/BaseDialog/BaseDialog';

import styles from 'shared/ui/ModalContainer/ModalContainer.css';

export interface ModalContainerProps extends BaseDialogProps {
    modalContainerClassName?: string;
    closeOnOverlay?: boolean;
}

export const ModalContainer: React.FC<ModalContainerProps> = function ModalContainer({
    modalContainerClassName /* @TODO remove on sidebar remove */,
    className,
    hasOverlay = true,
    closeOnOverlay = true,
    onClose,
    children,
    ...otherProps
}) {
    const Portal = usePortal();

    usePreventScroll({ enabled: true });

    const onOverlayClick = closeOnOverlay ? onClose : undefined;

    return (
        <Portal>
            <div className={cn(styles.modalContainer, modalContainerClassName)}>
                <div className={styles.modalInnerContainer}>
                    <BaseDialog
                        {...otherProps}
                        className={cn(styles.modal, className)}
                        overlayClassName={styles.overlay}
                        hasOverlay={hasOverlay}
                        onClose={onClose}
                        onOverlayClick={onOverlayClick}
                    >
                        {children}
                    </BaseDialog>
                </div>
            </div>
        </Portal>
    );
};
