import * as React from 'react';
import cn from 'classnames';

import { Spin } from 'shared/ui/Spin/Spin';

import styles from 'shared/ui/PageLoading/PageLoading.css';

export interface PageLoadingProps {
    className?: string;
}

export const PageLoading: React.FC<PageLoadingProps> = React.memo(function PageLoading({ className }) {
    return (
        <div className={cn(styles.pageLoading, className)}>
            <Spin />
        </div>
    );
});
