import { buildDummyImageInline } from 'tests/storybook/helpers/buildDummyImageInline';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { Picture, PictureProps } from 'shared/ui/Picture/Picture';

const storybookMeta = createStorybookMeta<PictureProps>({
    title: 'shared/Picture',
    component: Picture,

    args: {
        src: buildDummyImageInline({ origUrl: 'https://vlootkit.cz' }),
        title: 'vlootkit.cz',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<PictureProps>(Picture);

export const normal = Template.bind({});
normal.args = {};

export const loading = Template.bind({});
loading.args = { isLoading: true };

export const error = Template.bind({});
error.args = { src: 'vlootkit.cz' };
