import * as React from 'react';
import cn from 'classnames';

import { Spin } from 'shared/ui/Spin/Spin';

import ErrorIcon from 'shared/ui/Icons/images/ban-16.inline.svg';

import styles from 'shared/ui/Picture/Picture.css';

export type PictureOptions = {
    src: Optional<string>;
    title: string;
};

export interface PictureProps extends PictureOptions {
    className?: string;
    isLoading?: boolean;
}

export const Picture: React.FC<PictureProps> = function Picture({ className, src, title, isLoading, children }) {
    const [loading, setLoading] = React.useState<boolean>();
    const [error, setError] = React.useState<boolean>();

    React.useEffect(() => {
        setLoading(Boolean(src));
    }, []);

    const onLoadHandler = React.useCallback(() => {
        setLoading(false);
        setError(false);
    }, []);

    const onErrorHandler = React.useCallback(() => {
        setError(true);
        setLoading(false);
    }, []);

    const hasSpin = isLoading || loading;

    return (
        <picture className={cn(styles.picture, className)}>
            {hasSpin && (
                <span className={styles.loading}>
                    <Spin />
                </span>
            )}

            {error && <ErrorIcon />}

            {src && !error && (
                <img
                    className={styles.image}
                    src={src}
                    alt={title}
                    loading="lazy"
                    onLoad={onLoadHandler}
                    onError={onErrorHandler}
                />
            )}

            {children}
        </picture>
    );
};
