import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { hoverState } from 'tests/storybook/helpers/hoverState';

import { RadioButton, RadioButtonItemOptions, RadioButtonProps } from 'shared/ui/RadioButton/RadioButton';

const storybookMeta = createStorybookMeta<RadioButtonProps>({
    title: 'shared/RadioButton',
    component: RadioButton,

    parameters: { backgrounds: { default: 'white' } },
});

export default storybookMeta;

const Template = createStorybookTemplate<RadioButtonProps>(RadioButton);

const ITEMS: RadioButtonItemOptions[] = [
    { label: 'All time', id: 'all' },
    { label: 'Last day', id: 'day' },
    { label: 'Last week', id: 'week' },
];

export const normal = Template.bind({});
normal.args = { items: ITEMS, value: 'all' };
normal.hermioneFn = hoverState;

export const disabledItem = Template.bind({});
disabledItem.args = {
    items: [
        { label: 'All time', id: 'all' },
        { label: 'Last day', id: 'day' },
        { label: 'Last week', id: 'week', disabled: true },
    ],
    value: 'day',
};
disabledItem.hermioneFn = hoverState;

export const disabled = Template.bind({});
disabled.args = { items: ITEMS, value: 'all', disabled: true };
