import * as React from 'react';
import { useLocation } from 'react-router-dom';

import { setScrollTop } from 'shared/helpers/setScrollTop/setScrollTop';

export const RouterScrollTop: React.FC = function RouterScrollTop({ children }) {
    const location = useLocation();

    React.useEffect(() => {
        setScrollTop(0);
    }, [location.pathname]);

    return <>{children}</>;
};
