import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { ScoringSize } from 'shared/consts/ScoringSize';
import { Scoring, ScoringProps } from 'shared/ui/Scoring/Scoring';

const storybookMeta = createStorybookMeta<ScoringProps>({
    title: 'shared/Scoring',
    component: Scoring,
});

export default storybookMeta;

const Template = createStorybookTemplate<ScoringProps>(Scoring);

export const greenM = Template.bind({});
greenM.args = { value: 10 };

export const yellowM = Template.bind({});
yellowM.args = { value: 6 };

export const redM = Template.bind({});
redM.args = { value: 3 };

export const noneM = Template.bind({});

export const greenL = Template.bind({});
greenL.args = { size: ScoringSize.L, value: 10 };

export const yellowL = Template.bind({});
yellowL.args = { size: ScoringSize.L, value: 6 };

export const redL = Template.bind({});
redL.args = { size: ScoringSize.L, value: 3 };

export const noneL = Template.bind({});
noneL.args = { size: ScoringSize.L };
