import * as React from 'react';

import { GlobalShimmer } from 'shared/ui/GlobalShimmer/GlobalShimmer';
import { LayoutContainer, LayoutContainerProps } from 'shared/ui/LayoutContainer/LayoutContainer';

export type SectionLayoutProps = LayoutContainerProps;

export const SectionLayout: React.FC<SectionLayoutProps> = function SectionLayout({ children, ...otherProps }) {
    return (
        <GlobalShimmer>
            <LayoutContainer {...otherProps}>{children}</LayoutContainer>
        </GlobalShimmer>
    );
};
