import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { Select, SelectProps } from 'shared/ui/Select/Select';

const storybookMeta = createStorybookMeta<SelectProps>({
    title: 'shared/Select',
    component: Select,

    args: {
        storybookWidth: '320px',

        items: [
            {
                label: 'Driver',
                value: 'driver',
            },
            {
                label: 'Car',
                value: 'car',
            },
            {
                label: 'Licence plate number',
                value: 'licence-number',
            },
            {
                label: 'Mileage',
                value: 'mileage',
            },
        ],
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<SelectProps>(Select);

async function menuActions(browser: WebdriverIO.Browser, selector: string) {
    const menuEl = '[role="menu"]';

    await browser.$(selector).click();
    await browser.$(menuEl).waitForDisplayed();
    await browser.assertView('opened', [selector, menuEl]);

    await browser.$('li[role="option"]:nth-child(2)').click();
    await browser.$(menuEl).waitForDisplayed({ reverse: true });

    return browser.assertView('closed', selector);
}

export const normal = Template.bind({});
normal.args = { placeholder: 'Select' };
normal.hermioneFn = menuActions;

export const empty = Template.bind({});
empty.hermioneFn = menuActions;

export const singleSelected = Template.bind({});
singleSelected.args = { placeholder: 'Select', checkedMenu: 'driver' };
singleSelected.hermioneFn = menuActions;

export const multipleSelected = Template.bind({});
multipleSelected.args = { placeholder: 'Select', checkedMenu: ['driver', 'car'], multiple: true };
multipleSelected.hermioneFn = async function (browser, selector) {
    const menuEl = '[role="menu"]';

    await browser.$(selector).click();
    await browser.$(menuEl).waitForDisplayed();
    await browser.assertView('opened', [selector, menuEl]);

    await browser.$('li[role="option"]:nth-child(3)').click();
    await browser.assertView('checked-option', [selector, menuEl]);

    await browser.$('body').moveTo({ xOffset: 1, yOffset: 1 });
    await browser.$('body').click();
    await browser.$(menuEl).waitForDisplayed({ reverse: true });

    return browser.assertView('closed', selector);
};

export const disabled = Template.bind({});
disabled.args = { placeholder: 'Select', disabled: true };

export const disabledSelected = Template.bind({});
disabledSelected.args = { placeholder: 'Select', checkedMenu: 'driver', disabled: true };

export const withBackground = Template.bind({});
withBackground.args = { withBackground: true };
