import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { InputSize } from 'shared/consts/InputSize';
import { SelectEditable, SelectEditableProps } from 'shared/ui/SelectEditable/SelectEditable';

const storybookMeta = createStorybookMeta<SelectEditableProps>({
    title: 'shared/SelectEditable',
    component: SelectEditable,

    args: {
        storybookWidth: '320px',

        inputSize: InputSize.M,
        items: [
            {
                label: 'Driver',
                value: 'driver',
            },
            {
                label: 'Car',
                value: 'car',
            },
            {
                label: 'Licence plate number',
                value: 'licence-number',
            },
            {
                label: 'Mileage',
                value: 'mileage',
            },
        ],
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<SelectEditableProps>(SelectEditable);

async function menuActions(browser: WebdriverIO.Browser, selector: string) {
    const menuEl = '[role="menu"]';

    await browser.$(selector).click();
    await browser.$(menuEl).waitForDisplayed();
    await browser.assertView('opened', [selector, menuEl]);

    await browser.$('li[role="option"]:nth-child(2)').click();
    await browser.$(menuEl).waitForDisplayed({ reverse: true });

    return browser.assertView('closed', selector);
}

export const normal = Template.bind({});
normal.args = { placeholder: 'Select' };
normal.hermioneFn = menuActions;

export const empty = Template.bind({});
empty.hermioneFn = menuActions;

export const withText = Template.bind({});
withText.args = { value: 'Input text' };
withText.hermioneFn = menuActions;

export const selected = Template.bind({});
selected.args = { placeholder: 'Select', checkedMenu: 'driver' };
selected.hermioneFn = menuActions;
