import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { hoverState } from 'tests/storybook/helpers/hoverState';

import { TabSize } from 'shared/consts/TabSize';
import { TabItem, TabItemProps } from 'shared/ui/TabItem/TabItem';

const storybookMeta = createStorybookMeta<TabItemProps>({
    title: 'shared/TabItem',
    component: TabItem,

    args: {
        label: 'Overview',
        value: 'overview',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<TabItemProps>(TabItem);

export const sizeM = Template.bind({});
sizeM.args = { size: TabSize.M };
sizeM.hermioneFn = hoverState;

export const sizeL = Template.bind({});
sizeL.args = { size: TabSize.L };
sizeL.hermioneFn = hoverState;

export const activeM = Template.bind({});
activeM.args = { size: TabSize.M, active: true };
activeM.hermioneFn = hoverState;

export const activeL = Template.bind({});
activeL.args = { size: TabSize.L, active: true };
activeL.hermioneFn = hoverState;

export const disabled = Template.bind({});
disabled.args = { size: TabSize.M, disabled: true };
