import * as React from 'react';
import cn from 'classnames/bind';

import { TabSize } from 'shared/consts/TabSize';
import { Button, ButtonProps } from 'shared/ui/Button/Button';

import styles from 'shared/ui/TabItem/TabItem.css';

export interface TabItemOptions extends Pick<ButtonProps, 'tagName' | 'href' | 'label' | 'disabled' | 'onClick'> {
    active?: boolean;
    value: string;
}

export interface TabItemProps extends TabItemOptions {
    className?: string;
    size: TabSize;
    currentItem?: string;

    onItemClick?(event: React.MouseEvent<HTMLAnchorElement | HTMLButtonElement>): void;
}

const cx = cn.bind(styles);

export const TabItem: React.FC<TabItemProps> = function TabItem({
    className,
    size,
    currentItem,
    onItemClick,
    active,
    value,
    disabled,
    onClick,
    ...otherProps
}) {
    const isActive = active || currentItem === value;
    const isDisabled = disabled && !isActive;

    return (
        <Button
            {...otherProps}
            className={cx(styles.tabItem, { active: isActive, disabled: isDisabled }, [size, className])}
            disabled={isDisabled}
            onClick={onClick || onItemClick}
            data-value={value}
        />
    );
};
