import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { Table, TableProps } from 'shared/ui/Table/Table';

const storybookMeta = createStorybookMeta<TableProps>({
    title: 'shared/Table',
    component: Table,

    args: {
        children: (
            <>
                <Table.Head>
                    <Table.Row>
                        <Table.Th>Date & time</Table.Th>
                        <Table.Th>Driver</Table.Th>
                        <Table.Th>Mileage</Table.Th>
                    </Table.Row>
                </Table.Head>
                <Table.Body>
                    <Table.Row>
                        <Table.Td>Jan 10 12:03 PM</Table.Td>
                        <Table.Td>Aleksey Cherenkevich</Table.Td>
                        <Table.Td>1 km</Table.Td>
                    </Table.Row>
                    <Table.Row>
                        <Table.Td>Jan 10 12:03 PM</Table.Td>
                        <Table.Td>Aleksey Cherenkevich</Table.Td>
                        <Table.Td>1 km</Table.Td>
                    </Table.Row>
                    <Table.Row>
                        <Table.Td>Jan 10 12:03 PM</Table.Td>
                        <Table.Td>Aleksey Cherenkevich</Table.Td>
                        <Table.Td>1 km</Table.Td>
                    </Table.Row>
                </Table.Body>
            </>
        ),
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<TableProps>(Table);

export const normal = Template.bind({});
