import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { TabSize } from 'shared/consts/TabSize';
import { Tabs, TabsProps } from 'shared/ui/Tabs/Tabs';

const storybookMeta = createStorybookMeta<TabsProps>({
    title: 'shared/Tabs',
    component: Tabs,

    args: {
        items: [
            {
                label: 'Overview',
                active: true,
                value: 'overview',
            },
            {
                label: 'Rides',
                value: 'rides',
            },
            {
                label: 'Signals',
                value: 'signals',
            },
            {
                label: 'Telematics',
                value: 'telematics',
            },
        ],
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<TabsProps>(Tabs);

export const sizeM = Template.bind({});
sizeM.args = { size: TabSize.M };

export const sizeL = Template.bind({});
sizeL.args = { size: TabSize.L };
