import * as React from 'react';
import cn from 'classnames';

import { TabItem, TabItemOptions, TabItemProps } from 'shared/ui/TabItem/TabItem';

import styles from 'shared/ui/Tabs/Tabs.css';

export interface TabsProps extends Pick<TabItemProps, 'size' | 'currentItem'> {
    className?: string;
    items: TabItemOptions[];

    onItemClick?(current: Nullable<string>): void;
}

export const Tabs: React.FC<TabsProps> = React.memo(function Tabs({
    className,
    size,
    items,
    currentItem,
    onItemClick,
}) {
    const onItemClickHandler = React.useCallback(
        ({ currentTarget }: React.MouseEvent<HTMLAnchorElement | HTMLButtonElement>) => {
            if (onItemClick) {
                const currentValue = currentTarget.getAttribute('data-value');

                onItemClick(currentValue);
            }
        },
        [onItemClick],
    );

    return (
        <div className={cn(styles.tabs, className)}>
            {items.map(({ value, ...otherProps }) => (
                <TabItem
                    {...otherProps}
                    className={styles.tabItem}
                    size={size}
                    currentItem={currentItem}
                    onItemClick={onItemClickHandler}
                    value={value}
                    key={value}
                />
            ))}
        </div>
    );
});
