import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { Tag, TagProps } from 'shared/ui/Tag/Tag';

const storybookMeta = createStorybookMeta<TagProps>({
    title: 'shared/Tag',
    component: Tag,

    parameters: { backgrounds: { default: 'white' } },

    args: {
        label: 'Driver',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<TagProps>(Tag);

export const normal = Template.bind({});

export const disabled = Template.bind({});
disabled.args = { disabled: true };

export const clear = Template.bind({});
clear.args = { hasClear: true };

export const clearDisabled = Template.bind({});
clearDisabled.args = { disabled: true, hasClear: true };
