import * as React from 'react';
import cn from 'classnames/bind';

import { Button } from 'shared/ui/Button/Button';

import CloseIcon from 'shared/ui/Icons/images/close-16.inline.svg';

import styles from 'shared/ui/Tag/Tag.css';

export interface TagProps {
    className?: string;
    label: string;

    disabled?: boolean;
    hasClear?: boolean;

    onClick?(event: React.MouseEvent<HTMLButtonElement>): void;
}

const cx = cn.bind(styles);

export const Tag: React.FC<TagProps> = function Tag({ className, label, disabled, hasClear, onClick }) {
    return (
        <span className={cx(styles.tag, { disabled }, [className])}>
            <span
                className={styles.label}
                title={label}
            >
                {label}
            </span>

            {hasClear && (
                <Button
                    className={styles.buttonRemove}
                    icon={CloseIcon}
                    onClick={onClick}
                />
            )}
        </span>
    );
};
