import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { TextWithDotSize } from 'shared/consts/TextWithDotSize';
import { TextWithDot, TextWithDotProps } from 'shared/ui/TextWithDot/TextWithDot';

import styles from 'shared/ui/TextWithDot/TextWithDot.story.css';

const storybookMeta = createStorybookMeta<TextWithDotProps>({
    title: 'shared/TextWithDot',
    component: TextWithDot,

    args: {
        storybookStyles: { font: '15px / 24px "YS Text", "Helvetica Neue", Arial, sans-serif' },

        children: 'Text',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<TextWithDotProps>(TextWithDot);

export const normal = Template.bind({});
normal.args = {};

export const L = Template.bind({});
L.args = {
    size: TextWithDotSize.L,
};

export const green = Template.bind({});
green.args = {
    className: styles.green,
};
