import * as React from 'react';
import cn from 'classnames/bind';

import { TextWithDotSize } from 'shared/consts/TextWithDotSize';

import styles from 'shared/ui/TextWithDot/TextWithDot.css';

const cx = cn.bind(styles);

export interface TextWithDotProps {
    className?: string;

    size?: TextWithDotSize;
    pulsar?: boolean;
    reverse?: boolean;
}

export const TextWithDot: React.FC<TextWithDotProps> = function TextWithDot({
    className,
    size = TextWithDotSize.M,
    pulsar,
    reverse,
    children,
}) {
    return (
        <span className={cx(styles.textWithDot, { pulsar }, [size, className])}>
            {!reverse && <span className={cx(styles.kropka, { left: true })} />}

            {children}

            {reverse && <span className={cx(styles.kropka, { right: true })} />}
        </span>
    );
};
