import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { hoverState } from 'tests/storybook/helpers/hoverState';

import { TextareaSize } from 'shared/consts/TextareaSize';
import { Textarea, TextareaProps } from 'shared/ui/Textarea/Textarea';

const storybookMeta = createStorybookMeta<TextareaProps>({
    title: 'shared/Textarea',
    component: Textarea,

    args: {
        storybookWidth: '320px',

        textareaSize: TextareaSize.M,
        spellCheck: false,
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<TextareaProps>(Textarea);

async function hoverTextareaState(browser, selector) {
    await hoverState(browser, selector);

    await browser.$(selector).click();

    return browser.assertView('focused', selector);
}

export const normal = Template.bind({});
normal.args = { value: 'Textarea text', hasClear: true };
normal.hermioneFn = hoverTextareaState;

export const empty = Template.bind({});

export const long = Template.bind({});
long.args = {
    value: "Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
    hasClear: true,
};

export const placeholder = Template.bind({});
placeholder.args = { placeholder: 'Placeholder text' };

export const error = Template.bind({});
error.args = { value: 'Textarea text', hasError: true };
error.hermioneFn = hoverTextareaState;

export const disabled = Template.bind({});
disabled.args = { placeholder: 'Placeholder text', disabled: true };
disabled.parameters = { backgrounds: { default: 'white' } };

export const disabledText = Template.bind({});
disabledText.args = { placeholder: 'Placeholder text', value: 'Textarea text', disabled: true };
disabledText.parameters = { backgrounds: { default: 'white' } };

export const expandable = Template.bind({});
expandable.args = {
    expandable: true,
    value: 'The quick\nbrown fox\njumps over the\nlazy dog',
};
