import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { hoverState } from 'tests/storybook/helpers/hoverState';

import { Toggle, ToggleProps } from 'shared/ui/Toggle/Toggle';

const storybookMeta = createStorybookMeta<ToggleProps>({
    title: 'shared/Toggle',
    component: Toggle,

    args: {
        storybookStyles: { lineHeight: 0 },

        id: 'copy-properties',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<ToggleProps>(Toggle);

export const normal = Template.bind({});
normal.args = { label: 'Copy properties' };
normal.hermioneFn = hoverState;

export const checked = Template.bind({});
checked.args = { label: 'Copy properties', checked: true };
checked.hermioneFn = hoverState;

export const disabled = Template.bind({});
disabled.args = { label: 'Copy properties', disabled: true };

export const checkedDisabled = Template.bind({});
checkedDisabled.args = { label: 'Copy properties', checked: true, disabled: true };

export const withoutLabel = Template.bind({});

export const withoutLabelChecked = Template.bind({});
withoutLabelChecked.args = { checked: true };
