import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { TooltipTailPosition } from 'shared/consts/TooltipTailPosition';
import { TooltipTailSide } from 'shared/consts/TooltipTailSide';
import { Tooltip, TooltipProps } from 'shared/ui/Tooltip/Tooltip';

const storybookMeta = createStorybookMeta<TooltipProps>({
    title: 'shared/Tooltip',
    component: Tooltip,

    parameters: {
        backgrounds: { default: 'white' },
    },

    hermioneSelector: ['[role="tooltip"]', 'svg'],

    args: {
        storybookWidth: '512px',

        text: "Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.",
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<TooltipProps>(Tooltip);

export const normal = Template.bind({});
normal.args = {
    title: "Lorem Ipsum has been the industry's standard dummy",
};
normal.hermioneSelector = '[role="tooltip"]';

export const textOnly = Template.bind({});
textOnly.hermioneSelector = '[role="tooltip"]';

export const topStart = Template.bind({});
topStart.args = { showTail: true, tailSide: TooltipTailSide.TOP, tailPosition: TooltipTailPosition.START };

export const topCenter = Template.bind({});
topCenter.args = { showTail: true, tailSide: TooltipTailSide.TOP, tailPosition: TooltipTailPosition.CENTER };

export const topEnd = Template.bind({});
topEnd.args = { showTail: true, tailSide: TooltipTailSide.TOP, tailPosition: TooltipTailPosition.END };

export const bottomStart = Template.bind({});
bottomStart.args = { showTail: true, tailSide: TooltipTailSide.BOTTOM, tailPosition: TooltipTailPosition.START };

export const bottomCenter = Template.bind({});
bottomCenter.args = { showTail: true, tailSide: TooltipTailSide.BOTTOM, tailPosition: TooltipTailPosition.CENTER };

export const bottomEnd = Template.bind({});
bottomEnd.args = { showTail: true, tailSide: TooltipTailSide.BOTTOM, tailPosition: TooltipTailPosition.END };

export const leftStart = Template.bind({});
leftStart.args = { showTail: true, tailSide: TooltipTailSide.LEFT, tailPosition: TooltipTailPosition.START };

export const leftCenter = Template.bind({});
leftCenter.args = { showTail: true, tailSide: TooltipTailSide.LEFT, tailPosition: TooltipTailPosition.CENTER };

export const leftEnd = Template.bind({});
leftEnd.args = { showTail: true, tailSide: TooltipTailSide.LEFT, tailPosition: TooltipTailPosition.END };

export const rightStart = Template.bind({});
rightStart.args = { showTail: true, tailSide: TooltipTailSide.RIGHT, tailPosition: TooltipTailPosition.START };

export const rightCenter = Template.bind({});
rightCenter.args = { showTail: true, tailSide: TooltipTailSide.RIGHT, tailPosition: TooltipTailPosition.CENTER };

export const rightEnd = Template.bind({});
rightEnd.args = { showTail: true, tailSide: TooltipTailSide.RIGHT, tailPosition: TooltipTailPosition.END };
