import * as React from 'react';
import cn from 'classnames/bind';

import { TooltipTailPosition } from 'shared/consts/TooltipTailPosition';
import { TooltipTailSide } from 'shared/consts/TooltipTailSide';

import ArrowIcon from 'shared/ui/Icons/images/arrow-24x8.inline.svg';

import styles from 'shared/ui/Tooltip/Tooltip.css';

export interface TooltipProps {
    className?: string;

    title?: React.ReactNode;
    text?: React.ReactNode;

    showTail?: boolean;
    tailSide?: TooltipTailSide;
    tailPosition?: TooltipTailPosition;

    tailRef?: React.MutableRefObject<Nullable<HTMLElement>>;

    children?: React.ReactNode;
}

const cx = cn.bind(styles);

export const Tooltip = React.forwardRef<HTMLDivElement, TooltipProps>(function Tooltip(
    { className, title, text, showTail, tailSide, tailPosition, tailRef, children },
    ref,
) {
    return (
        <div
            className={cn(styles.tooltip, className)}
            ref={ref}
            role="tooltip"
        >
            {showTail && (
                <span
                    className={cx(styles.tail, [tailSide, tailPosition])}
                    ref={tailRef}
                >
                    <ArrowIcon className={styles.tailIcon} />
                </span>
            )}

            {typeof title === 'string' ? (
                <h4 className={cn(styles.title)}>{title}</h4>
            ) : (
                title && <div className={styles.title}>{title}</div>
            )}

            {text && <div className={styles.text}>{text}</div>}

            {children}
        </div>
    );
});
