import * as React from 'react';
import cn from 'classnames/bind';

import { Island } from 'shared/ui/Island/Island';
import { TopTableRow } from 'shared/ui/TopTableRow/TopTableRow';

import { i18n } from 'shared/ui/TopTable/TopTable.i18n';

import styles from 'shared/ui/TopTable/TopTable.css';

export interface TopTableItem {
    id: string | number;
    text: React.ReactNode;
    value: React.ReactNode | string | number;
}

export interface TopTableProps {
    className?: string;

    title: React.ReactNode;

    header?: Array<string | undefined>;
    items: TopTableItem[];
    isLoading: boolean;
}

const LOADING_TOP: TopTableItem[] = [{}, {}, {}, {}, {}] as TopTableItem[];
const cx = cn.bind(styles);

export const TopTable: React.FC<TopTableProps> = function TopTable({
    className,
    title,
    header,
    items,
    isLoading,
    children,
}) {
    const hasItems = items.length > 0;

    return (
        <Island
            className={cx(styles.island, className)}
            title={<h3 className={styles.islandTitle}>{title}</h3>}
        >
            <div className={styles.top}>
                {header && (
                    <div className={cx(styles.topHeader, { borderBottom: !hasItems })}>
                        {header.map((head) => {
                            if (!head) {
                                return null;
                            }

                            return (
                                <div
                                    key={head}
                                    className={styles.topHeaderItem}
                                >
                                    {head}
                                </div>
                            );
                        })}
                    </div>
                )}

                {isLoading ? (
                    LOADING_TOP.map((item, index) => {
                        return (
                            <TopTableRow
                                key={index}
                                className={styles.row}
                            />
                        );
                    })
                ) : hasItems ? (
                    items.map(({ id, text, value }, index) => {
                        return (
                            <TopTableRow
                                key={id || index}
                                className={styles.row}
                                text={text}
                                value={value}
                            />
                        );
                    })
                ) : (
                    <div className={styles.noData}>{i18n('There is no data')}</div>
                )}
            </div>
        </Island>
    );
};
