import * as React from 'react';
import cn from 'classnames';

import { Shimmer } from 'shared/ui/Shimmer/Shimmer';

import styles from 'shared/ui/TopTableRow/TopTableRow.css';

export interface TopTableRowProps {
    className?: string;

    text?: React.ReactNode;
    value?: React.ReactNode | string | number;
}

export const TopTableRow: React.FC<TopTableRowProps> = function TopTableRow({ className, text, value }) {
    return (
        <div className={cn(styles.container, [className])}>
            {text ? (
                <>
                    <div className={styles.text}>{text}</div>
                    <div className={styles.count}>{value}</div>
                </>
            ) : (
                <Shimmer className={styles.carShimmer} />
            )}
        </div>
    );
};
