import * as React from 'react';
import cn from 'classnames/bind';

import styles from 'shared/ui/Widget/Widget.css';

export interface WidgetProps {
    className?: string;
    style?: React.CSSProperties;
    role?: React.AriaRole;

    contentContainer?: boolean;

    children: React.ReactNode;

    'data-id'?: string;
    onMouseEnterItem?(event: React.MouseEvent<HTMLDivElement>): void;
    onMouseLeaveItem?(): void;
    onClick?(event: React.MouseEvent<HTMLDivElement>): void;
}

const cx = cn.bind(styles);

export const Widget = React.forwardRef<HTMLDivElement, WidgetProps>(function Widget(
    { className, style, role, contentContainer, children, onMouseEnterItem, onMouseLeaveItem, onClick, ...props },
    ref,
) {
    return (
        <div
            className={cx(styles.widget, { contentContainer }, [className])}
            style={style}
            role={role}
            ref={ref}
            onMouseEnter={onMouseEnterItem}
            onMouseLeave={onMouseLeaveItem}
            onClick={onClick}
            data-id={props['data-id']}
        >
            {children}
        </div>
    );
});
