import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Something went wrong': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Something went wrong',
        ru: 'Что-то пошло не так',
        cs: 'Něco se pokazilo',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
