import * as React from 'react';

import { ErrorBoundary } from 'shared/ui/ErrorBoundary/ErrorBoundary';
import { Spin } from 'shared/ui/Spin/Spin';
import { Widget } from 'shared/ui/Widget/Widget';

import { i18n } from 'shared/ui/WidgetResourceBoundary/WidgetResourceBoundary.i18n';

import styles from 'shared/ui/WidgetResourceBoundary/WidgetResourceBoundary.css';

export interface WidgetResourceBoundaryProps {}

export const WidgetResourceBoundary: React.FC<WidgetResourceBoundaryProps> = function WidgetResourceBoundary({
    children,
}) {
    const loadingFallback = React.useMemo(() => {
        return (
            <Widget className={styles.container}>
                <Spin />
            </Widget>
        );
    }, []);

    const Fallback: React.FC<any> = React.useCallback(function Fallback() {
        return (
            <Widget className={styles.container}>
                <h3 className={styles.title}>{i18n('Something went wrong')}</h3>
            </Widget>
        );
    }, []);

    return (
        <ErrorBoundary fallback={Fallback}>
            <React.Suspense fallback={loadingFallback}>{children}</React.Suspense>
        </ErrorBoundary>
    );
};
