const DEFAULT_RETRIES_COUNT = 5;
const DEFAULT_RETRY_INTERVAL = 200;

const wait = (interval) => new Promise((resolve) => setTimeout(resolve, interval));
export async function asyncRetry(fn, retriesLeft = DEFAULT_RETRIES_COUNT, interval = DEFAULT_RETRY_INTERVAL) {
    try {
        return await fn();
    } catch (error) {
        await wait(interval);
        if (retriesLeft === 0) {
            throw new Error(error);
        }

        return await asyncRetry(fn, --retriesLeft, interval);
    }
}
