import { EMPTY_DATA } from 'constants/constants';

import { getLang } from 'utils/language/getLang';

import { i18n } from 'utils/car/getMileageString.i18n';

export const getMileageString = (mileageInKilometers?: number | null) => {
    if (typeof mileageInKilometers !== 'number' || isNaN(mileageInKilometers)) {
        return EMPTY_DATA;
    }

    let mileage = +mileageInKilometers.toFixed(1);

    return i18n('{value} km', { value: Math.trunc(mileage).toLocaleString(getLang()) });
};
