import { CarSignalqTraitSchema } from 'entities/Car/types/CarSignalqTraitSchema';

import { ILeasingStats, StatusTypes } from 'components/types';

export interface ICarInfo extends Partial<CarSignalqTraitSchema> {
    id: string;
    number: string;
    vin: string;
    model_id: string;
    model: string;
    status: StatusTypes;
    view: number;
    taxi_park: string;
    location: {
        lat: number;
        lon: number;
        course: number;
        tags: any[];
    };
    telematics?: {
        speed: number;
        ext_voltage: number;
        mileage: number;
        fuel_level: any[] | number;
        fuel_distance?: number;
        is_engine_on?: boolean;
        gsm_signal_level?: number;
        VEGA_GPS_INVIEW?: number;
        gps_used?: number;
        engine_temperature?: number | string;
    };
    signalq?: {
        serial_number: string;
        imei?: string;
    };
    speed: number;
    tags?: any[];
    leasing_stats: ILeasingStats;
    taxi_company: {
        name: string;
        id: string;
    };
}

export interface ICarImei {
    imei: string;
}

export interface ICarScoring {
    aggressive_rank: number;
}
