import { ONE_SECOND } from 'constants/constants';

import { getI18nLocale } from 'utils/language/getI18nLocale';

export default function shortDateTime(timestamp) {
    let locale = getI18nLocale();

    return new Date(timestamp * ONE_SECOND)?.toLocaleString(locale, {
        day: 'numeric',
        month: 'short',
        hour: '2-digit',
        minute: '2-digit',
    });
}
