import { getFlags } from 'utils/getFlags';

export enum CarDashboardPage {
    FLEET = 'fleet',
    RENTAL = 'rental',
}

export function getCarDashboardFlag(): Optional<CarDashboardPage> {
    const flags = getFlags();
    const dashboard = flags?.car_dashboard;

    if (dashboard === CarDashboardPage.RENTAL) {
        return CarDashboardPage.RENTAL;
    }

    if (dashboard !== undefined) {
        return CarDashboardPage.FLEET;
    }

    return;
}
