import { HOST_MATCH } from 'constants/constants';

export enum ENV {
    testing = 'testing',
    prestable = 'prestable',
    prod = 'prod',
}

export default function getEnv() {
    const origin = location.origin;

    if (origin.includes('localhost')) {
        return process.env.DM_BACKEND_CLUSTER || ENV.prod;
    }

    const originMatch = origin.match(HOST_MATCH);

    return originMatch?.[2] || ENV.prod;
}
