import { LS_FLAGS } from 'constants/constants';

import { isValidJSONString } from 'utils/isValidJSONString';
import { SupportedLanguage } from 'utils/language/types';

import { I18nLocale } from 'shared/consts/I18nLocale';

// @todo: move to entities/Flags
interface IFlags {
    lang?: SupportedLanguage;
    center?: [number, number];
    dashboardComponent?: string;
    area_tags?: string | null;
    flag_car_panic_buttons?: boolean;
    car_models_for_block?: string[] | null;
    is_admin?: boolean;
    showCarsGroups?: boolean;
    show_car_scoring?: boolean;
    show_car_status_filters?: boolean;
    show_car_camera_status_filters?: boolean;
    show_taxi_company_rides?: boolean;
    show_car_scoring_median?: boolean;
    show_users_section?: boolean;
    show_car_driver_in_rides?: boolean;
    show_car_service?: boolean;
    manage_car_doors?: boolean;
    add_new_signal?: boolean;
    switch_env?: boolean;
    show_env_version?: boolean;
    show_acceptance_photos?: boolean;
    show_users_rides?: boolean;
    show_organization_group_info?: boolean;
    custom_cities_filter?: ICustomFilterItem[];
    carlove_custom_filters?: Record<string, ICustomFilterItem[]>;
    beacon_search_mode?: boolean;
    zones?: boolean;
    show_user_scoring_informer?: boolean;
    cars_schedule?: boolean;
    car_alarm_system?: boolean;
    car_maintenance?: boolean;
    car_overview?: boolean;
    car_overview_edit?: boolean;
    car_telematics_password?: boolean;
    car_add?: boolean;
    signals_redesign?: boolean;
    user_profile_page?: boolean;
    user_documents_page?: boolean;
    show_hardware_filter?: boolean;
    hardware_filter_ids?: string[];
    user_details_address?: boolean;
    showSessions?: boolean;
    showNotificationPage?: boolean;
    showTelematics?: boolean;
    telematics_config?: boolean;
    car_signal_resolution?: boolean;
    car_damage?: boolean;
    car_dashboard?: string;
    car_dashboard_scoring: boolean;
    rides_booking_columns?: boolean;
    signals_source_filter?: boolean | string[];
    signals_support?: boolean;
    rental_retiree_flow?: boolean;
    enableCarAssignment?: boolean;
    enableAddUsers?: boolean;
    showSettingsTags?: boolean;
    settings_pricing?: boolean;
}

export interface ICustomFilterItem extends Record<I18nLocale, string> {
    tag: string;
}

export const getFlags = (): IFlags | null => {
    try {
        const flagsLS = localStorage.getItem(LS_FLAGS);

        return flagsLS && isValidJSONString(flagsLS) ? JSON.parse(flagsLS) : null;
    } catch (e) {
        return null;
    }
};
