import { isVlootkit } from 'shared/helpers/isVlootkit/isVlootkit';

const DOMAIN_TLD = isVlootkit() ? /^(.+\.)?vlootkit\.(com|cz)$/ : /^(.+\.)?yandex\.(ru|com|eu)$/;

export function getTLD() {
    const hostname = location.hostname;
    const match = hostname ? hostname.match(DOMAIN_TLD) : null;

    return match ? match[2] : 'com';
}
